
#pragma once

#ifdef  _WINDOWS_SOURCE
#define ExportedByCMICusCallback     __declspec(dllexport)
#else
#define CMICusCallback
#endif


class CATUnicodeString;

#include "IUnknown.h"
#include "CATBoolean.h"

extern "C"
{
	ExportedByCMICusCallback HRESULT CMICusPrepareSynchronize(CATUnicodeString &usFeedback, CATBoolean &bCancel);
/*
Called after Command is activated but before Synchronize dialog is filled.

usFeedback 		String can be set and will be piped through to consecutive customizing messages, eg. to suspend the custom actions.
bCancel			Return bCancel==true to cancel the Command. Customization is responsible for user message.
HRESULT 		S_OK if success
				E_FAIL if failure
				Failure does not stop processing. 
*/
	ExportedByCMICusCallback HRESULT CMICusPreSynchronize (CATUnicodeString &usFeedback, CATBoolean &bCancel);
/*
Called after Synchronize button is pushed before Synchronze  starts.

usFeedback 		String is supplied and will be piped through to consecutive customizing messages, eg. to suspend the custom actions.
bCancel			Return bCancel==true to cancel the action. Customization is responsible for user message. Synchronize button will be in deactivated state.
HRESULT 		S_OK if success
				E_FAIL if failure
				Failure does not stop processing.
*/
	ExportedByCMICusCallback HRESULT CMICusPostSynchronize (const CATUnicodeString &usFeedback, const CATBoolean bCompleted);
/*
Called after Synchronize button is pushed and Synchronize is complete.

usFeedback 		String is supplied.
bCompleted		TRUE if Synchronize succeeded
HRESULT 		S_OK if success
				E_FAIL if failure
				Failure does not stop processing.
*/
	ExportedByCMICusCallback HRESULT CMICusPostRead (CATUnicodeString &usFeedback, CATBoolean &bWarning);
/*
Called after Read is complete and files are already open in CATIA.

usFeedback 		Return string that will be shown in the CMI result Window.
bWarning		If TRUE, Read will end with success and usFeedback is shown in the Information tab.
				If FALSE, Read will end with Warnings, and usFeedback is shown in the Warnings tab.
HRESULT 		S_OK if success
				E_FAIL if failure
				In case of failure no error is displayed in the CMI Read result window and usFeedback is not shown.
*/
}


