//=================================================================== 
// COPYRIGHT T-Systemes International GmbH 2004
//===================================================================
//
// CMIReadApi.h
// Header definition of CMIReadApi
//
//===================================================================
//
// Usage notes:
//
// You have to use this API within the CMI CATIA session.
// Do not use this API within an external application.
//
//===================================================================

#ifndef CMIReadApi_H
#define CMIReadApi_H

//-------------------------------------------------------------------

/**
 * CMIReadApi
 * <p>
 * API to perform a CMI Read from CMI Workbench action
 *
 * You have to use this API within the interactive CATIA session. 
 * Do not use this API within an external application. 
 * The CMI READ API uses the address space of the interactive CATIA session.
 *
 * the CMI environment has to be sourced to let API work correctly
 */

#ifdef  _WINDOWS_SOURCE
#define ExportedByCMIReadApi     __declspec(dllexport)
#else
#define ExportedByCMIReadApi
#endif

#include "IUnknown.h"

class ExportedByCMIReadApi CMIReadApi
{

public:

	////////////////////////////////////////////////
	// CMIRead
	//
	// calls the CMIReadCommand Activate message and
	// performs the standard CMI Read action
	//
	// RETURN .... always CATReturnSuccess
	//
	////////////////////////////////////////////////
	static HRESULT CMIRead();

};

//-----------------------------------------------------------------------

#endif
