// COPYRIGHT T-Systemes 2004
//===================================================================
//
// CMILinxApi.h
// Header definition of CMILinxApi
//
//===================================================================
//
// Usage notes:
//
// You have to use this API within the CMI CATIA session.
// Do not use this API within an external application.
//
//===================================================================
//
//  Aug 2004  Creation: Code generated by the CAA wizard  catusr1
//===================================================================
#ifndef CMILinxApi_H
#define CMILinxApi_H

//-----------------------------------------------------------------------

/**
 * Describe your class here.
 * <p>
 * Using this prefered syntax will enable mkdoc to document your class.
 */

#ifdef  _WINDOWS_SOURCE
#define ExportedByCMILinxApi     __declspec(dllexport)
#else
#define ExportedByCMILinxApi
#endif


#pragma warning(disable: 4091)
#include "CATIProduct.h"
#pragma warning(default: 4091)
#include "CATString.h"
#include "CATListOfCATString.h"


class ExportedByCMILinxApi CMILinxApi
{
	public:

	//////////////////////////////////////////////////////////////////////////
	// Get Reference Attributes                                             //
	//                                                                      //
	//                                                                      //
	// CMIGetReferenceAttributes                                            //
	//           IN: piProduct                                              //
	//                                                                      //
	//          OUT: sListOfAttributes  List of all CUSTOM_ATTRS at the     //
	//                                  related Part or DataItem            //
	//               sListOfValues      List of all CUSTOM_VALS at the      //
	//                                  related Part or DataItem            //
	//       RETURN: S_OK               OK                                  //
	//               E_FAIL             Lists of CUSTOM_ATTRS and           //
	//                                  CUSTOM_VALS have different size     //
	//                                                                      //
	// CMIGetReferenceAttribute                                             //
	//           IN: piProduct                                              //
	//               sAttribute         Attribute of CUSTOM_ATTRS at the    //
	//                                  related Part or DataItem            //
	//                                                                      //
	//          OUT: sValue             Related value of CUSTOM_VALS at     //
	//                                  the related Part or DataItem        //
	//       RETURN: S_OK               OK                                  //
	//               E_FAIL             Lists of CUSTOM_ATTRS and           //
	//                                  CUSTOM_VALS have different size     //
    //////////////////////////////////////////////////////////////////////////

	static HRESULT CMIGetReferenceAttributes(CATIProduct *piProduct,
		       CATListOfCATString *sListOfAttributes, 
		       CATListOfCATString *sListOfValues);

	static HRESULT CMIGetReferenceAttribute(CATIProduct *piProduct,
		   const CATString *sAttribute, CATString *sValue);

	//////////////////////////////////////////////////////////////////////////
	// Get Relation Attributes                                              //
	//                                                                      //
	//                                                                      //
	// CMIGetInstanceAttributes                                             //
	//           IN: piFatherProduct                                        //
	//               piProduct                                              //
	//                                                                      //
	//          OUT: slAttributes       List of all CUSTOM_ATTRS at the     //
	//                                  related relation                    //
	//               slValues           List of all CUSTOM_VALS at the      //
	//                                  related relation                    //
	//       RETURN: S_OK               OK                                  //
	//               E_FAIL             Lists of CUSTOM_ATTRS and           //
	//                                  CUSTOM_VALS have different size     //
	//                                                                      //
	// CMIGetInstanceAttribute                                              //
	//           IN: piFatherProduct                                        //
	//               piProduct                                              //
	//               sAttribute         Attribute of CUSTOM_ATTRS at the    //
	//                                  related relation                    //
	//                                                                      //
	//          OUT: sValue             Related value of CUSTOM_VALS at     //
	//                                  the related relation                //
	//       RETURN: S_OK               OK                                  //
	//               E_FAIL             Lists of CUSTOM_ATTRS and           //
	//                                  CUSTOM_VALS have different size     //
    //////////////////////////////////////////////////////////////////////////

	static HRESULT CMIGetInstanceAttributes(CATIProduct *piFatherProduct,
	       CATIProduct *piProduct,
		   CATListOfCATString *sListOfAttributes, 
		   CATListOfCATString *sListOfValues);

	static HRESULT CMIGetInstanceAttribute(CATIProduct *piFatherProduct,
		   CATIProduct *piProduct,
		   const CATString *sAttribute, CATString *sValue);

	private:
	//nodoc
	static CATListOfCATString GetValuesOfList (const CATString &sList);

};

//-----------------------------------------------------------------------

#endif
