//===================================================================
// COPYRIGHT T-Systems 2022.02.09
//===================================================================
// TestCMIAPI.cpp
// Header definition of class TestCMIAPI
//===================================================================
//
// Usage notes:
//
//===================================================================
//  2022.02.09 Creation: Code generated by the 3DS wizard
//===================================================================

#include "TestCMIAPI.h"
#include "CATFrmLayout.h"
#include "CATFrmWindow.h"
#include "CATFrmEditor.h"
#include "CATIEditor.h"
#include "CATIDocRoots.h"
#include "CATDlgNotify.h"
#include "CATApplicationFrame.h"

#include "CMIToolboxApi.h"

#include "CATCreateExternalObject.h"
CATCreateClass( TestCMIAPI);

//-------------------------------------------------------------------------
// Constructor
//-------------------------------------------------------------------------
TestCMIAPI::TestCMIAPI() :
CATCommand (NULL, "TestCMIAPI")
{
RequestStatusChange (CATCommandMsgRequestExclusiveMode);
}

//-------------------------------------------------------------------------
// Destructor
//-------------------------------------------------------------------------
TestCMIAPI::~TestCMIAPI()
{
}


//  Overload this method: when your command gains focus
//
// Activates a command.
//   iFromClient :The command that requests to activate the current one.
//   iEvtDat :The notification sent.
// ----------------------------------------------------
CATStatusChangeRC TestCMIAPI::Activate( CATCommand * iFromClient, CATNotification * iEvtDat)
{
	CATDlgNotify* pDlgNotify = NULL;
	CATUnicodeString usMessage;
	
	CATDocument *pDocument = GetCurrentWindow();
	if (pDocument)
	{
		CATIProduct_var spProductOnRoot = NULL_var;
		HRESULT hr = GetProductFromDocument(pDocument, spProductOnRoot);

		if (SUCCEEDED(hr) && !!spProductOnRoot)
		{
			CATString sValue;
			CATString sReturnCode;
			hr = CMIGetPartAttributeFromTC(spProductOnRoot,
				                           "Class",
				                           sValue,
				                           sReturnCode);
			if (SUCCEEDED(hr))
			{	
				if (hr == S_OK)
				{
					pDlgNotify = new CATDlgNotify(CATApplicationFrame::GetApplicationFrame()->GetApplicationDocument(),
						"", CATDlgNfyOK | CATDlgWndModal);
				}
				else
				{
					pDlgNotify = new CATDlgNotify(CATApplicationFrame::GetApplicationFrame()->GetApplicationDocument(),
						"", CATDlgNfyWarning | CATDlgWndModal);
				}
				usMessage = CATUnicodeString("Value     : ") + sValue.ConvertToChar();
				usMessage += CATUnicodeString("\nReturnCode: ") + sReturnCode.ConvertToChar();
			}
			else
			{
				pDlgNotify = new CATDlgNotify(CATApplicationFrame::GetApplicationFrame()->GetApplicationDocument(),
					"", CATDlgNfyError | CATDlgWndModal);
				usMessage = "CMI Toolbox API Failed";
			}		
		}
	}
	else
	{
		pDlgNotify = new CATDlgNotify(CATApplicationFrame::GetApplicationFrame()->GetApplicationDocument(),
			"", CATDlgNfyError | CATDlgWndModal);
		usMessage = "Cannot get top level CATProduct";
	}

	pDlgNotify->DisplayBlocked(usMessage, "CMI Toolbox API");

	RequestDelayedDestruction();
	return (CATStatusChangeRCCompleted);
}

//  Overload this method: when your command loses focus
//
// Deactivates a command.
//   iFromClient :The command that requests to activate the current one.
//   iEvtDat :The notification sent.
// ----------------------------------------------------
CATStatusChangeRC TestCMIAPI::Desactivate( CATCommand * iFromClient, CATNotification * iEvtDat)
{
	RequestDelayedDestruction();
	return (CATStatusChangeRCCompleted);
}

//  Overload this method: when your command is canceled
//
// Cancel a command.
//   iFromClient :The command that requests to activate the current one.
//   iEvtDat :The notification sent.
// ----------------------------------------------------
CATStatusChangeRC TestCMIAPI::Cancel( CATCommand * iFromClient, CATNotification * iEvtDat)
{
	RequestDelayedDestruction();
	return (CATStatusChangeRCCompleted);
}

CATDocument* TestCMIAPI::GetCurrentWindow()
{
	CATFrmLayout *pCurrLayout = CATFrmLayout::GetCurrentLayout();
	CATFrmWindow *pWindow = NULL;
	if (pCurrLayout == NULL)
	{
		return NULL;
	}

	pWindow = pCurrLayout->GetCurrentWindow();
	if (pWindow == NULL)
	{
		return NULL;
	}

	CATFrmEditor *pEditor = pWindow->GetEditor();
	if (pEditor == NULL)
	{
		return NULL;
	}

	CATDocument *pDocument = pEditor->GetDocument();
	if (pDocument == NULL)
	{
		return NULL;
	}
	return pDocument;
}


HRESULT TestCMIAPI::GetProductFromDocument(CATDocument *pDoc, CATIProduct_var &spProductOnRoot)
{
	HRESULT hr = E_FAIL;
	if (pDoc == NULL)
	{
		return E_FAIL;
	}

	CATIEditor *piEditor = NULL;
	hr = pDoc->QueryInterface(IID_CATIEditor, (void**)&piEditor);
	if (FAILED(hr) || (piEditor == NULL))
	{
		return E_FAIL;
	}
	CATIDocRoots *piDocRootsOnDoc = NULL;
	hr = piEditor->QueryInterface(IID_CATIDocRoots,
		(void**)&piDocRootsOnDoc);
	if (FAILED(hr) || (piDocRootsOnDoc == NULL))
	{
		return E_FAIL;
	}

	CATLISTV(CATBaseUnknown_var) *pRootProducts =
		piDocRootsOnDoc->GiveDocRoots();

	CATIProduct_var spRootProduct = NULL_var;
	if (pRootProducts)
	{
		if (pRootProducts->Size())
		{
			spProductOnRoot = (*pRootProducts)[1];
		}
		delete pRootProducts;
		pRootProducts = NULL;
	}
	else
	{
		return E_FAIL;
	}
	piDocRootsOnDoc->Release();
	piDocRootsOnDoc = NULL;

	// clean up
	piEditor->Release();
	piEditor = NULL;

	if (!spProductOnRoot)
	{
		return E_FAIL;
	}
	return S_OK;
}