// COPYRIGHT DASSAULT SYSTEMES 2002

// Local Framework
#include "CAAAfrGeneralWksAdn.h"
// #include "CAAAfrMRUHeader.h"

// ApplicationFrame Framework 
#include "CATCreateWorkshop.h"
#include "CATAfrCheckHeaderAccessor.h"

// Creates the CAAAfrGeneralWksHeader command header class
#include "CATCommandHeader.h"
MacDeclareHeader(CAAAfrGeneralWksAddinHeader);  


//----------------------------------------------------------------------------
// To create the TIE Object
#include <TIE_CATIAfrGeneralWksAddin.h>
TIE_CATIAfrGeneralWksAddin(CAAAfrGeneralWksAdn);

// To declare that the class 
// is a DataExtension of (late type) CAAAfrGeneralWksAddin
//
CATImplementClass(CAAAfrGeneralWksAdn, DataExtension, 
                  CATBaseUnknown, CAAAfrGeneralWksAddin);

// 
// To declare that CAAAfrGeneralWksAddin implements CATIAfrGeneralWksAddin, insert 
// the following line in the interface dictionary:
//
//   CAAAfrGeneralWksAddin  CATIAfrGeneralWksAddin libCAAAfrGeneralWksAddin
//
//---------------------------------------------------------------------------


CAAAfrGeneralWksAdn::CAAAfrGeneralWksAdn()
{
}

CAAAfrGeneralWksAdn::~CAAAfrGeneralWksAdn()
{
}


//-----------------------------------------------------------------------------
// CreateCommands
//-----------------------------------------------------------------------------
void CAAAfrGeneralWksAdn::CreateCommands()
{

  // Search Demonstrator
  // -------------------
  //
  // CAAAfrSearchHdr        : identifier of the command header
  // CAACafSearch           : name of the module exporting the Search demonstrator command 
  // CAACafSearchCmd        : name of the command class 
  // NULL                   : no argument for the CAACafSearchCmd command class
  //
  new CAAAfrGeneralWksAddinHeader("CAAAfrSearchHdr", 
                             "CAAAfrGeneralWksAddin", 
                             "TestCMIAPI", (void *)NULL);

}

//-----------------------------------------------------------------------------
// CreateToolbars
//-----------------------------------------------------------------------------
CATCmdContainer *CAAAfrGeneralWksAdn::CreateToolbars()
{
  //----------------------
  // Toolbar 
  //----------------------
  NewAccess(CATCmdContainer, pCAAAfrGeneralWksTlb, CAAAfrGeneralWksTlb);
  
  NewAccess(CATCmdStarter, pCAAAfrSearchStr, CAAMmrGeneralSearchStr);
  SetAccessCommand(pCAAAfrSearchStr, "CAAAfrSearchHdr");
  SetAccessChild(pCAAAfrGeneralWksTlb, pCAAAfrSearchStr);
  
  AddToolbarView(pCAAAfrGeneralWksTlb, 1, Right); 

  return pCAAAfrGeneralWksTlb;
}

